// To parse this JSON data, do
//
//     final nomineeListResponseModel = nomineeListResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/savings/savings_response_model.dart';

NomineeListResponseModel nomineeListResponseModelFromJson(String str) => NomineeListResponseModel.fromJson(json.decode(str));

String nomineeListResponseModelToJson(NomineeListResponseModel data) => json.encode(data.toJson());

class NomineeListResponseModel {
  final String? remark;
  final String? status;
  final Message? message;
  final List<Nominee>? data;

  NomineeListResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NomineeListResponseModel.fromJson(Map<String, dynamic> json) => NomineeListResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? [] : List<Nominee>.from(json["data"]!.map((x) => Nominee.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data == null ? [] : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}
